<?php

function getInfo() {
    $info = [];

    // User Info
    $info['ip'] = getUserIP();
    $info['user_agent'] = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    $info['accept_language'] = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? 'Unknown';
    $info['accept_encoding'] = $_SERVER['HTTP_ACCEPT_ENCODING'] ?? 'Unknown';
    $info['https'] = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'Yes' : 'No';
    $info['current_timestamp'] = date('Y-m-d H:i:s');
    $info['device'] = detectDevice($_SERVER['HTTP_USER_AGENT'] ?? '');

    // Convert array to formatted string
    $formattedInfo = '';
    foreach ($info as $key => $value) {
        $formattedInfo .= $key . ': ' . $value . PHP_EOL;
    }

    return $formattedInfo;
}

/**
 * Get Real IP Address
 */
function getUserIP() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } elseif (!empty($_SERVER['REMOTE_ADDR'])) {
        return $_SERVER['REMOTE_ADDR'];
    } else {
        return 'Unknown';
    }
}

/**
 * Basic Device Detection
 */
function detectDevice($userAgent) {
    $userAgent = strtolower($userAgent);
    if (strpos($userAgent, 'mobile') !== false) {
        return 'Mobile';
    } elseif (strpos($userAgent, 'tablet') !== false) {
        return 'Tablet';
    } elseif (strpos($userAgent, 'windows') !== false || strpos($userAgent, 'linux') !== false || strpos($userAgent, 'macintosh') !== false) {
        return 'Desktop';
    } else {
        return 'Unknown';
    }
}
