<?php
error_reporting(0);
session_start(); 
require 'config.php';

// Generate or retrieve a persistent user session ID
if (!isset($_SESSION['user_session'])) {
    $_SESSION['user_session'] = bin2hex(random_bytes(16)); // Secure 32-character session ID
}

// Global user session variable
$userSession = $_SESSION['user_session'];
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$restApiUrl = "https://spamtools.org/wp-json/spamtools/v1/"; // REST API base URL
$hashToken = $token; 

/**
 * Function to send data via REST API
 *
 * @param string $endpoint REST API endpoint ('add-subscription-data' or 'fetch-subscription-data')
 * @param array $data Associative array of data to send
 * @return array|false Decoded JSON response or false on failure
 */
function sendData($endpoint, $data)
{
    global $restApiUrl, $hashToken, $userSession;

    $url = $restApiUrl . $endpoint;
    $data['hash'] = $hashToken; // Automatically add the hash token
    $data['user_session'] = $userSession; // Ensure the same user session is used

    $jsonData = json_encode($data);

    // Initialize cURL session
    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Content-Length: ' . strlen($jsonData),
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // Enable SSL verification
    curl_setopt($ch, CURLOPT_TIMEOUT, 15); // Timeout limit

    // Execute the request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Handle cURL errors
    if (curl_errno($ch)) {
        curl_close($ch);
        return false;
    }

    curl_close($ch);

    // Decode and return response as an array
    return json_decode($response, true);
}

?>