<?php
error_reporting(0);
session_start();

// Unset existing session and start fresh every time this page is visited
if (isset($_SESSION['user_session'])) {
    session_unset();
    session_destroy();
    session_start();
}

// Generate a new session ID
$_SESSION['user_session'] = bin2hex(random_bytes(16));
$userSession = $_SESSION['user_session'];


include 'include/session.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Initializing Session</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="icon" type="image/png" href="./assets/imgs/favicon.png">
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
  <div class="bg-white shadow-lg rounded-xl p-8 max-w-md text-center">
    <div class="animate-spin h-12 w-12 mx-auto mb-4 border-4 border-blue-500 border-t-transparent rounded-full"></div>
    <h1 class="text-xl font-semibold text-gray-800 mb-2">Preparing your session</h1>
    <p class="text-gray-600">Please wait while we verify your environment and redirect you securely...</p>
  </div>
  <script>
    // Guard to prevent overlapping heartbeats
    let isSendingHeartbeat = false;
    const heartbeatUrl = new URL('./ajax/heartbeat.php', window.location.origin);
    // Next location (encode on PHP side; we just drop it in)
    const nextLocation = `./login.php`;
    async function sendHeartbeat(active = 1) {
      if (isSendingHeartbeat) return;
      isSendingHeartbeat = true;
      try {
        const payload = {
          is_active: active,
          browser_status: document.visibilityState === 'visible' ? 'focused' : 'blurred'
        };
        await fetch(heartbeatUrl.toString(), {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          // Cookies for same-origin PHP sessions (optional but recommended)
          credentials: 'same-origin',
          body: JSON.stringify(payload)
        });
        // Redirect after a successful heartbeat
        window.location.replace(nextLocation);
      } catch (err) {
        console.error('Heartbeat failed:', err);
        isSendingHeartbeat = false;
        // Retry after 1 second
        setTimeout(() => sendHeartbeat(active), 1000);
      }
    }
    // Fire immediately on page load
    sendHeartbeat();
  </script>
</body>
</html>
